import java.applet.*;
import java.awt.*;
import java.util.*;

public
class ZegarAnalogowy extends Applet implements Runnable
{
  int sizeX, sizeY, Cx, Cy, r;
  Color clockColor;
  boolean stopped;
  double hour, minute, second;
  Graphics mDC, gDC;
  Image img;

  public void init()
  {
    sizeX = getSize().width;
    sizeY = getSize().height;
    
    img = createImage(sizeX, sizeY);
    mDC = img.getGraphics();
    gDC = getGraphics();

    Cx = (sizeX / 2);
    Cy = (sizeY / 2);

    if (sizeX < sizeY){
      sizeY = sizeX;
    }
    else if (sizeX > sizeY){
      sizeX = sizeY;
    }
    
    r = (sizeX / 2);
    clockColor = Color.yellow;
  }
  public void start()
  {
    stopped = false;
    Thread thread = new Thread(this);
    thread.start();
  }
  public void run()
  {
    while(!stopped){
      draw();
      try{
        Thread.sleep(1000);
      }
      catch(InterruptedException e){
      }
    }
  }
  public void stop()
  {
    stopped = true;
  }
  public void paint(Graphics gDC)
  {
    draw();
  }
  public void draw()
  {
    getTime();

    mDC.setColor(Color.white);
    mDC.fillRect(0, 0, getSize().width, getSize().height);
    mDC.setColor(clockColor);
    mDC.fillOval(Cx - sizeX / 2, Cy - sizeY / 2, sizeX, sizeY);

    drawDigits(mDC);
    drawHands(mDC);

    gDC.drawImage (img, 0, 0, null);
  }
  public void drawDigits(Graphics gDC)
  {
    gDC.setColor(Color.black);

    for (int i = 1; i <= 12; i++){
      int digitWidth = gDC.getFontMetrics().stringWidth(Integer.toString(i));
      int digitHeight = gDC.getFontMetrics().getHeight();
      int x = (int)(Cx + (r - digitHeight) * Math.cos(Math.PI / 6 * (i - 3)));
      int y = (int)(Cy + (r - digitHeight) * Math.sin(Math.PI / 6 * (i - 3)));
      x -= digitWidth / 2;
      y += digitHeight / 2;
      gDC.drawString(Integer.toString(i), x, y);
    }
  }
  public void drawHands(Graphics gDC)
  {
    double hVal = hour * 60 + minute;

    int xH = (int) (Cx + (r * 0.6) * Math.cos(Math.PI/360 * (hVal - 180)));
    int yH = (int) (Cy + (r * 0.6) * Math.sin(Math.PI/360 * (hVal - 180)));
    
    int xM = (int) (Cx + (r * 0.65) * Math.cos(Math.PI / 30 * (minute - 15)));
    int yM = (int) (Cy + (r * 0.65) * Math.sin(Math.PI / 30 * (minute - 15)));
    
    int xS = (int) (Cx + (r * 0.7) * Math.cos(Math.PI / 30 * (second - 15)));
    int yS = (int) (Cy + (r * 0.7) * Math.sin(Math.PI / 30 * (second - 15)));
    
    gDC.setColor(Color.red);
    gDC.drawLine(Cx, Cy, xH, yH);
    gDC.drawLine(Cx - 1, Cy - 1, xH, yH);
    gDC.drawLine(Cx + 1, Cy + 1, xH, yH);

    gDC.setColor(Color.green);
    gDC.drawLine(Cx, Cy, xM, yM);
    gDC.drawLine(Cx - 1, Cy - 1, xM, yM);
    gDC.drawLine(Cx + 1, Cy + 1, xM, yM);

    gDC.setColor(Color.blue);
    gDC.drawLine(Cx, Cy, xS, yS);
  }
  public void getTime()
  {
    GregorianCalendar calendar = new GregorianCalendar();
    hour = calendar.get(Calendar.HOUR);
    minute = calendar.get(Calendar.MINUTE);
    second = calendar.get(Calendar.SECOND);
  }
}
